﻿using Microsoft.CodeAnalysis.CSharp.Syntax;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Edu.Library.Mathematics
{
    public class Fraction
    {
        public int Numerator { get; private set; }
        public int Denominator { get; private set; }

        public Fraction(int numerator, int denominator)
        {
            if (denominator == 0) throw new ArgumentException("Denominator cannot be 0!");
            Numerator = numerator;
            Denominator = denominator;
        }

        public Fraction(int numerator) : this(numerator, 1) { }

        public static int Euclid(int a, int b)
        {
            int c, r;
            do
            {
                //c = a / b;
                r = a % b;
                a = b;
                b = r;
            } while (r != 0);
            return a;
        }

        public static int SmallestMultiple(int a, int b)
        {
            var greatestDivisor = Euclid(a, b);
            return a * b / greatestDivisor;
        }

        public void Simplify()
        {
            var cmmdc = Euclid(Numerator, Denominator);
            Numerator /= cmmdc;
            Denominator /= cmmdc;
        }

        public void Amplify(int factor)
        {
            Numerator *= factor;
            Denominator *= factor;
        }

        public void Invert()
        {
            if (Numerator == 0) throw new ArgumentException("0 cannot be inverted!");
            var tmp = Numerator;
            Numerator = Denominator;
            Denominator = tmp;
        }

        public override string ToString()
        {
            return $"{Numerator}/{Denominator}";
        }

        public override bool Equals(object? obj)
        {
            var fraction = obj as Fraction;
            if (fraction == null) return false;
            var p1 = Numerator * fraction.Denominator;
            var p2 = Denominator * fraction.Numerator;
            return p1 == p2;
        }

        public override int GetHashCode()
        {
            var clone = Clone();
            clone.Simplify();
            var value = Numerator / (double)Denominator;
            var hashCode = value.GetHashCode();
            return hashCode;
        }

        public Fraction Clone()
        {
            var obj = MemberwiseClone();
            var clone = obj as Fraction;
            return clone;
        }

        public static Fraction operator *(Fraction f1, Fraction f2)
        {
            var result = new Fraction(f1.Numerator * f2.Numerator, f1.Denominator * f2.Denominator);
            return result;
        }

        public static Fraction operator /(Fraction f1, Fraction f2)
        {
            var invF2 = f2.Clone();
            invF2.Invert();
            var result = f1 * invF2;
            return result;
        }

        public static Fraction operator +(Fraction f1, Fraction f2)
        {
            var fa = f1.Clone();
            fa.Simplify();
            var fb = f2.Clone();
            fb.Simplify();
            var smallestMultiple = SmallestMultiple(fa.Denominator, fb.Denominator);
            fa.Amplify(smallestMultiple / fa.Denominator);
            fb.Amplify(smallestMultiple / fb.Denominator);
            var result = new Fraction(fa.Numerator + fb.Numerator, smallestMultiple);
            return result;
        }

        public static Fraction operator -(Fraction f1, Fraction f2)
        {
            var fb = new Fraction(-1) * f2.Clone();
            var result = f1 + fb;
            return result;
        }
    }
}
